---
library_name: transformers
license: apache-2.0
datasets:
- HuggingFaceM4/the_cauldron
- HuggingFaceM4/Docmatix
pipeline_tag: image-text-to-text
language:
- en
base_model:
- HuggingFaceTB/SmolLM2-360M-Instruct
- google/siglip-base-patch16-512
tags:
- mlx
---

# mlx-community/SmolVLM-500M-Instruct-4bit
This model was converted to MLX format from [`HuggingFaceTB/SmolVLM-500M-Instruct`]() using mlx-vlm version **0.1.11**.
Refer to the [original model card](https://huggingface.co/HuggingFaceTB/SmolVLM-500M-Instruct) for more details on the model.
## Use with mlx

```bash
pip install -U mlx-vlm
```

```bash
python -m mlx_vlm.generate --model mlx-community/SmolVLM-500M-Instruct-4bit --max-tokens 100 --temp 0.0 --prompt "Describe this image." --image <path_to_image>
```
